# BARRACKS -  NOTES
# *YES* to take Vials leads to combat
# also leads to arrest attempts and many encounters with 
#
# *NO* leads to the Guards offering a quest to party later...
# The quest is to go and deal with Yeodaugh 
# This path leads to Townie encounters...
#
from eventAPI import *
from APIUtils import *
from SDLKeys import SDLK_y, SDLK_n, SDLK_l
import genericBarracks

# lFlagU: local event instance bitfield
#       hex description
#         0 Fresh event
#  FFFFFFFF Finished event, fires generic barracks
lFlagU = 0

VialBarracks1 = 0

def fireEvent(e):
    global lFlagU, VialBarracks1
    lFlagU = getTag(e, "lFlagU")
    VialBarracks1 = getTag(e, "VialBarracks1")
    PltF1 = getTag(e, "PltF1")
    if ((lFlagU == 1) or
        (PltF1 != 1)):
        genericBarracks.fireEvent(e)
        return 0
    showPicture(e, "Red_Flask")
    playSpecAudio(e, "Barracks")
    if (poseYesNo(e,
        ["There is a guard sleeping nearby.",
         "As you look around and notice a strange collection of blood red vials on a small wooden table.",
         "",
         "Will you sneak across the room and take the vials?"])):
        giveItems(e, ["Unknown Vial (Red)", "Unknown Vial (Red)", "Unknown Vial (Red)"])
        guardsArrive(e)
    else:
        VialBarracks1 = 1
    setTag(e, "VialBarracks1", VialBarracks1)
    setTag(e, "lFlagU", lFlagU)
    return 0

def guardsArrive(e):
    global VialBarracks1
    showPicture(e, "Guard_of_Rennibister")
    playSpecAudio(e, "Barracks")
    showMessage(e,
        ["Guardians of Rennibister:",
         "",
         "\"We demand the vials back! We are seizing all contraband and arresting all smugglers!",
         "Will you hand them over to us peacefully or do we have to use force?\""])
    choice = optionInput(e,
        ["\"What will it BE?! Will you hand over the vials or shall we cut you down like crooked weeds you are? ...ANSWER!\""],
        ["(Y)es.  Our mistake.", "(N)ot today!"],
        [SDLK_y, SDLK_n])
    if (choice == SDLK_y):
        returnedFlasks(e)
        return
    combatRet = combat(e, [("Guardian of Rennibister", 2, 0, 20)])
    if (combatRet == 1):
        wonCombat(e)
    elif (combatRet != 3):
        # ran away
        VialBarracks1 = 3
    else:
        lostCombat(e)

def returnedFlasks(e):
    global lFlagU, VialBarracks1
    optionInput(e,
        ["\"Very wise choice you have made. You can be assured that we will dispel the evil that cast its stench in our goodly walls. Do not meddle in that which you do not understand.\"",
         "",
         "\"If you seek adventure, we MAY have a quest for you another time. Keep your eyes and ears open.\""],
        ["(L)eave the Barracks"], [SDLK_l])
    VialBarracks1 = 4
    removeAllItems(e, "Unknown Vial (Red)")
    setTag(e, "PltF1", getTag(e, "PltF1") | 0xA) # turn on townie gangs, and Naris is no longer home
    lFlagU = 1

def wonCombat(e):
    global VialBarracks1, lFlagU
    showPicture(e, "Barracks")
    playSpecAudio(e, "Barracks")
    showMessage(e,
        ["Having defeated the guards, you search the barracks for more vials.",
         "You look in every corner, but find nothing more than spare armor and weapons of aged bronze."])
    giveItems(e, ["Chain Mail", "Elven Gauntlets", "Two-Handed Sword"])
    showPicture(e, "Barracks")
    playSpecAudio(e, "Barracks")
    showMessage(e,
        ["You realize the great harm you may have done and start to feel nervous about the consequences.",
         "It's time to leave with a quickness."])
    VialBarracks1 = 2
    PltF1 = getTag(e, "PltF1")
    PltF1 |= 0xC            # turn on arrests, and Naris is not home anymore
    setTag(e, "PltF1", PltF1)
    lFlagU = 1
    showMessage(e, ["You leave the barracks..."])
    setExit(e, "maps/renibister.cfg", 8, 33, 270)

def lostCombat(e):
    global VialBarracks1
    # lost combat, all dead
    showPicture(e, "Guard_of_Rennibister")
    playSpecAudio(e, "Barracks")
    showMessage(e,
        ["The red-blooded guard with dark and deep set eyes laughs at your foolishness.",
         "You lie on the hard stone floor, choking on your own blood.",
         "",
         "\"We'll be taking this back now. Leave town now and never return.\"",
         "",
         "The guard, forsaking all you quested for, reaches down and rips the vial of unknown liquid",
         "from your weakening fingers, leaving you with nothing."])
    # Take 3 vials back
    removeAllItems(e, "Unknown Vial (Red)")
    VialBarracks1 = 3
    # don't set lFlagU differently, as they should be able to come back and try again if
    #  they like
