#Fight 1, upon entering the Temple of the Elements
from eventAPI import *
from APIUtils import *

TotEFight1 = 0

def fireEvent(e):
    global TotEFight1
    TotEFight1 = getTag(e, "TotEFight1")
    if (TotEFight1 == 0):
        return begin(e)
    elif (TotEFight1 == 1):
        return alreadylost(e)
    elif (TotEFight1 == 2):
        return backformore(e)
    else:
        return 1

def begin(e):
    showMessage(e, ["After descending into the underground, you take a moment to get a sense of your surroundings.  As you gather your thoughts you notice the stone walls appear to be moving."])
    showMessage(e, ["Within mere moments, The walls come to life and take the shape of stone golems. They look angry that you have disturbed their realm and the party is quickly surrounded."])
    showMessage(e, ["You brace yourselves for the imminent battle.", "", "I think you're in trouble."])
    return fight(e)
    
def fight(e):
    combatRet = combat(e, [("Stone Golem", 150, 0, 10)])
    if (combatRet == 1):
        wonCombat(e)
        return 1
    elif (combatRet == 2):
        ranaway(e)
        return 0
    else:
        lostCombat(e)

def wonCombat(e):
    setTag(e, "TotEFight1", 3)
    showMessage(e, ["After a grueling battle, all of the stone golems lie in pieces before you.  This may be a sign of things to come."])
    
def lostCombat(e):
    setTag(e, "TotEFight1", 1)
    showMessage(e, ["You find that you have become another victim of the evil terrors of the Temple of the Elements."])
    
def ranaway(e):
    setTag(e, "TotEFight1", 2)
    showMessage(e, ["As you scamper off like a bunch of pansies, the stone golems return to their resting place, not wasting their efforts on chasing you down."])
    
def alreadylost(e):
    showMessage(e, ["After barely escaping eternal damnation during your last battle, you foolishly seek out revenge."])
    return fight(e)
    
def backformore(e):
    showMessage(e, ["Despite the streak of yellow across your backs, you bravely come back for another whipping."])
    return fight(e)
