from eventAPI import *
from APIUtils import *
from SDLKeys import *

def fireEvent(e):
    if ((getTag(e, "lFlagS") & 0x100) == 0):
        return 1
    k = getTag(e, "kssCrypt")
    if (k <= 20):
        return 1
    elif (k == 29):
        setTag(e, "kssCrypt", 30)
        showMessage(e, ["Muffled thumps can be heard nearby."])
        return 1
    elif (k == 37):
        setTag(e, "kssCrypt", 38)
        showMessage(e, ["You hear a distinct scratching sound."])
        return 1
    elif (k == 45):
        setTag(e, "kssCrypt", 50)
        showMessage(e, ["With a loud creak the crypt's stone door opens wide.", "",
                        "After a moment of hesitation, you step inside and find a stairway, dimly lit by candles.",
                        "", "You climb down the steps."])
        showPicture(e, "kssgarzz")
        showMessage(e, ["A strangely familiar ghost is busy arranging surprisingly good looking pieces of armor and weaponry.", "",
                        "\"Welcome to Garzz's Emporium.\" he exclaims.", "", "\"Extraordinary equipment for exorbitant prices. No refunds.\""])
        return shop(e, 0)
    elif (k>=50):
        showPicture(e, "kssgarzz")
        return shop(e, 0)
    else:
        showMessage(e, ["When you approach this sealed crypt, you hear a faint whisper."])
        setTag(e, "kssCrypt", 22)
        return 1


def shop(e, k):
    if (getTag(e, "kssCrypt") <= 55): 
        choice = optionInput(e, ["Make your choice", "", "(A)rmor", "(B)laded weapons", "B(l)unt weapons", "(R)anged weapons", "", "", "", "I might have a task too, for those who know the password..."], ["(ESCAPE) to Exit"],
            [SDLK_a, SDLK_b, SDLK_c, SDLK_d, SDLK_e, SDLK_f, SDLK_g, SDLK_h, SDLK_i, SDLK_j, SDLK_k, SDLK_l, SDLK_m, SDLK_n, SDLK_o, SDLK_p, SDLK_q, SDLK_r, SDLK_s, SDLK_t, SDLK_u, SDLK_w, SDLK_x, SDLK_y, SDLK_z, SDLK_SPACE, SDLK_ESCAPE])
    elif (getTag(e, "kssCrypt") >= 80):
        if (getTag(e, "kssCrypt") == 80):
            showMessage(e, ["Garzz is overjoyed at your victory.","","\"The dread mutt whose bark caused me to fall and break my neck is no more. I am avenged, and you now have full access to my inventory."])
            setTag(e, "kssCrypt", 85)                
        choice = optionInput(e, ["Make your choice", "", "(A)rmor", "(B)laded weapons", "B(l)unt weapons", "(R)anged weapons", "", "", "", "(U)nique"], ["(ESCAPE) to Exit"],
            [SDLK_a, SDLK_b, SDLK_l, SDLK_r, SDLK_u, SDLK_ESCAPE])
    else: 
        choice = optionInput(e, ["Make your choice", "", "(A)rmor", "(B)laded weapons", "B(l)unt weapons", "(R)anged weapons", "", "", "", "(T)ask"], ["(ESCAPE) to Exit"],
            [SDLK_a, SDLK_b, SDLK_l, SDLK_r, SDLK_t, SDLK_ESCAPE])
    if (choice == SDLK_a):
        k = 0
        buy(e, ["Star Plate", "Health Belt", "Elf Boots", "Kyle's Bracers", "Star Gauntlets", "Star Helm"],
            [250000, 10000, 2000, 15000, 10000, 8000])  
    elif (choice == SDLK_b):
        k = 0
        buy(e, ["Star Axe", "Star War Axe", "Emerald Dagger", "Star Short Sword", "Star Sword", "Ceridwen's Sword"],
            [15000, 25000, 4000, 8000, 25000, 25000])
    elif (choice == SDLK_l):
        k = 0
        buy(e, ["Rune Mace", "Runic War Hammer", "Magika Staff", "Rune Staff", "Elvenkind Staff"],
            [2000, 10000, 8000, 2000, 10000])
    elif (choice == SDLK_r):
        if (k == 8):
            k = 0
            setTag(e, "kssCrypt", 60)
            showMessage(e, ["The password? How...","","Well, no matter.","I have a task for you: beneath this crypt, sealed behind seven wards, resides the one responsible for my demise.",""
                            "I yearn for revenge, and ask that you destroy him.","","I'll reward you with access to my most exclusive stock."])
            if (task(e)):
                return 0
        else:
            k = 0
            buy(e, ["Starkind Arrows (20)", "Starkind Bolts (10)", "Thunder Bolts (10)", "Starkind Bullets (20)", "Elf Bow"],
                   [3000, 3000, 5000, 1000, 6000])
    elif ((choice == SDLK_g) and (getTag(e, "kssCrypt") == 55)):
        k = 1
    elif (choice == SDLK_w):
        if (k == 1):
            k = 2
        else:
            k = 0
    elif (choice == SDLK_e):
        if (k == 2):
            k = 3
        elif (k == 7):
            k = 8
        else:
            k = 0
    elif (choice == SDLK_n):
        if (k == 3):
            k = 4
        else:
            k = 0
    elif (choice == SDLK_h):
        if (k == 4):
            k = 5
        else:
            k = 0
    elif (choice == SDLK_y):
        if (k == 5):
            k = 6
        else:
            k = 0
    elif (choice == SDLK_f):
        if (k == 6):
            k = 7
        else:
            k = 0
    elif ((choice == SDLK_t) and (getTag(e, "kssCrypt") >= 60)):
        if (getTag(e, "kssCrypt") == 70):
            showMessage(e, ["The beast killed you too?","","It is fearsome indeed but take heart, nothing is invincible."])
            setTag(e, "kssCrypt",60)
        if (task(e)):
            return 0
    elif ((choice == SDLK_u) and (getTag(e, "kssCrypt") == 85)):
        if (getTag(e, "kssArtifact") == 2047):
            showMessage(e, ["Sorry, but you've emptied my stock of unique items. Come back in a few thousand years."])
        else:
            artifact(e, 0)
    elif (choice == SDLK_ESCAPE):
        return 1
    else:
        k = 0
    return shop (e, k)

def task(e):
    if poseYesNo(e, ["Are you ready for this task?","","Be aware that the wards will prevent you from leaving until either you or the beast are dead."]):
        setExit(e, "maps/ksscrypt.cfg", 8, 1, 0)
        showMessage(e, ["Garzz leads you to a passage at the back of the crypt. After going down for a short while, you look behind you and see only a blank wall.",
                        "","You're sealed within."])
        setTag(e, "kssArtifact", 0)
        return 1
    else:
        showMessage(e, ["Let me know when you feel ready."])
        return 0

def buy(e, list, price):
    i = 0
    a = []
    k = [SDLK_ESCAPE]
    while i < len(list):
	a.append(str(i+1)+") "+list[i][:18])
	a.append("     "+str(price[i]))
	k.append(i+49)
	i += 1
    i = optionInput(e, a, ["(ESCAPE) to go back"], k)
    if (i == SDLK_ESCAPE):
        return 1
    if (modifyGold(e, 0, -price[i-49])):
        giveItems(e, [list[i-49]])
    else:
        broke(e)
    buy(e, list, price)

def artifact(e, l):
    list = ["Mana Gem", "Blade of 4 Elements", "Shamanic Shield", "Monk's Punching Gloves", "Holy Book", "Darklight Doubleblade",
            "Far Claw", "Belt of Titan Strength", "Everfull Flask", "Aruiberu's Bow and Quiver", "Death Dagger"]
    price = [150000, 250000, 100000, 125000, 125000, 150000, 150000, 125000, 125000, 200000, 200000]
    f = getTag(e, "kssArtifact")
    i = l
    end = 6+5*(l==6)
    a = []
    k = [SDLK_ESCAPE, SDLK_SPACE]
    while i < end:
	if (f&2**i):
            a.append(str(i-l+1)+") SOLD")
            a.append("")
        else:
            a.append(str(i-l+1)+") "+list[i][:16])
            a.append("     "+str(price[i]))
	k.append(i-l+49)
	i += 1
    i = optionInput(e, a, ["(Space) more", "(ESCAPE) to go back"], k)
    if (i == SDLK_ESCAPE):
        return 1
    if (i == SDLK_SPACE):
        artifact(e, 6-l)
        return 1
    if (f&2**(i+l-49)):
        if (random.randrange(1, 6)<3):
            showMessage(e, ["You already bought that one."])
        else:
            showMessage(e, ["I had only one of these."])
        artifact(e, l)
        return 1
    if (modifyGold(e, 0, -price[i+l-49])):
        giveItems(e, [list[i+l-49]])
        f|=2**(i+l-49)
        setTag(e, "kssArtifact", f)
    else:
        broke(e)
    if (f == 2047):
        return 1
    artifact(e, l)

def broke(e):
    k = random.randrange(1, 6)
    if (k < 2):
        showMessage(e, ["No gold, no nothing..."])
    elif (k < 3):
        showMessage(e, ["You don't have enough gold."])
    elif (k < 4):
        showMessage(e, ["You're broke, bloke !"])
    elif (k < 5):
        showMessage(e, ["Don't waste my time."])
    else:
        showMessage(e, ["Come back when you can pay, pal."])
    
