from eventAPI import *
from APIUtils import *
from SDLKeys import SDLK_y, SDLK_n, SDLK_l, SDLK_w
import genericEmptyHouse

# lFlagU: local event instance bitfield
#       val description
#         0 fresh event
#         1 Talked to Naris, accepted his call for help
#         2 Talked to Naris, refused his call for help once
#         3 Talked to Naris, refused his call for help twice
#         4 Returned to Naris from barracks already
lFlagU = 0

def fireEvent(e):
    global lFlagU
    lFlagU = getTag(e, "lFlagU")
    PltF1 = getTag(e, "PltF1")
    showPicture(e, "House")
    if (lFlagU != 0):
        if (PltF1 >= 8):
            if (lFlagU != 4):
                optionInput(e,["The house looks as if it has been hastily abandoned..."],["(L)eave the house"],[SDLK_l])
                lFlagU = 4
            else:
                genericEmptyHouse.fireEvent(e)
        elif (lFlagU == 1):
            returnedWithoutInvestigating(e)
        elif (lFlagU == 2):
            returnedWithoutAcceptingQuest(e)
        elif (lFlagU == 3):
            slamDoor(e)
    else:
        playSpecAudio(e, "House")
        answer = stringInput(e,
            ["As you knock on the door, a small slit appears, and you catch a glimpse of an old man peering out. Irritably, he asks you, \"What is my name?\""])
        if (answer.lower() == "naris"):
            runSection2(e)
        else:
            slamDoor(e)
    setTag(e, "lFlagU", lFlagU)
    return 0

def runSection2(e):
    global lFlagU
    showPicture(e, "Naris")
    playSpecAudio(e, "House")
    if (optionInput(e,
        ["\"Ever heard tell of poor ole Rip Canaughwinkel?",
         "Well, he drank this strange brew ye see and he was felled.",
         "Dead asleep like no sleep anyone has ever known.",
         "What do you think happened to him while he was asleep?\"",
         "",
         "\"What was happening that the likes of mine and thine could not see?",
         "Me suspects the town government of some nefarious plot not too unlike the plot behind ole Rip Canaughwinkel.",
         "Times are dark, times are dark me lads.\"",
         "",
         "I've heard word of corrupt Guardians of Rennibister secretly brewing such a Devil's work!",
         "If you do accept my bidding, the Guilds will honor you greatly and I'll have some gold for you when you return.",
         "Will you go and sort this out for me?\""],
        ["(Y)es, we will help", "(N)ot at this time"], [SDLK_y, SDLK_n]) == SDLK_y):
        acceptedQuest(e)
    else:
        begsPartyToAccept(e)

def returnedWithoutInvestigating(e):
    showPicture(e, "Naris")
    playSpecAudio(e, "House")
    optionInput(e,
        ["\"You have not yet gone to investigate the horrible events I have told you of?",
         "Art thou cowards that you cannot ace the deeds you've sworn to do?",
         "Begone, and return not until you have accomplished your task!\""],
        ["(L)eave the house"], [SDLK_l])

def acceptedQuest(e):
    global lFlagU
    optionInput(e,
        ["The old man continues:",
         "",
         "\"Very wise choice you have made.",
         "The guards are distilling their bewitching brew in the barracks, north of here.",
         "Bring back a vial of their creation so we have proof to put the wretches behind bars.",
         "Go, before any more harm befalls us!\""],
        ["(L)eave the house"], [SDLK_l])
    lFlagU = 1
    setTag(e, "PltF1", 1) # opens up 003_barracks

def begsPartyToAccept(e):
    global lFlagU
    if (optionInput(e,
        ["\"Very well, but may any further evil rising from these mysterious deeds be on your head!\""],
        ["(W)ait, we will help!", "(L)eave the house"], [SDLK_w, SDLK_l]) == SDLK_w):
        acceptedQuest(e)
    else:
        if (lFlagU == 0):
            lFlagU = 2
        elif (lFlagU == 2):
            lFlagU = 3
        setTag(e, "PltF1", 2) # Causes random encounters with townies
def returnedWithoutAcceptingQuest(e):
    global lFlagU
    showPicture(e, "Naris")
    playSpecAudio(e, "House")
    if (optionInput(e,
        ["\"You have returned!",
         "Have you reconsidered?",
         "Will you help me prove the misdeeds of these miscreants?\""],
        ["(Y)es, we will help", "(N)ot at this time"], [SDLK_y, SDLK_n]) == SDLK_y):
        acceptedQuest(e)
    else:
        begsPartyToAccept(e)

def slamDoor(e):
    showPicture(e, "House")
    playSpecAudio(e, "House")
    showMessage(e,
        ["The old man slams the door in your face!"])
    setTag(e, "PltF1", 0x04)
