#Western Castle floor 0 altar 1
from SDLKeys import SDLK_y, SDLK_n, SDLK_l
from eventAPI import *
from APIUtils import *

rtcastle0altar1 = 0

def fireEvent(e):
   global rtcastle0altar1
   rtcastle0altar1 = getTag(e, "rtcastle0altar1")
   if (rtcastle0altar1 == 2):
      altarComplete(e)
   elif (rtcastle0altar1 == 1):
      returnFigure(e)
   else:
      firstVisit(e)
   return 0


def firstVisit(e):
   showMessage(e, ["There is an altar of polished marble here.", "", "Upon the altar sits a black figurine of a demon."])
   text = ["Will you take the figurine?"]
   optionTexts = ["(Y)es", "(N)o"]
   optionsKeys = [SDLK_y, SDLK_n]
   if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
      giveItems(e, ["Obsidian Figurine"])
      rtcastle0altar1 = 1
      setTag(e, "rtcastle0altar1", rtcastle0altar1)
      return 0
   else:
      return 0

def returnFigure(e):
   i, max = 0, getPartyCount(e)
   hasFigure = 0
   while (i < max):
      if (hasItem(e, i, "Marble Figurine") & (rtcastle0altar1 == 1)):
         hasFigure = 1
         break
      i += 1
   text = ["You approach the marble altar."]
   if (hasFigure):
      optionTexts = ["(Y)es", "(N)o"]
      optionsKeys = [SDLK_y, SDLK_n]
      text.extend(["", "The marble figurine produces a ringing noise as you approach the altar", "", "Do you place the marble figurine upon the altar?"])
   else:
      optionTexts = ["(L)eave the Scene"]
      optionsKeys = [SDLK_l]
   if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
      removeFigure(e)


def removeFigure(e):
   i, max = 0, getPartyCount(e)
   hasFigure = 0
   while (i < max):
      if (hasItem(e, i, "Marble Figurine")):
         hasFigure = 1
         break
      i += 1
   removeItem(e, i, "Marble Figurine")
   playSpecAudio(e, "Bell_Toll2")
   showMessage(e, ["As you place the marble figurine upon the altar, you hear the sound of a bell tolling.", "", "The figurine and altar begin to glow with a soft blue light.  A faint ringing sound can be heard."])
   rtcastle0altar1 = 2
   setTag(e, "rtcastle0altar1", rtcastle0altar1)


def altarComplete(e):
   showMessage(e, ["The marble figurine and altar glow with a soft blue light.  A faint ringing sound can be heard."], optionInput)
   return 0