#Western Castle floor 0 altar 3
from SDLKeys import SDLK_y, SDLK_n, SDLK_l
from eventAPI import *
from APIUtils import *

rtcastle0altar3 = 0

def fireEvent(e):
   global rtcastle0altar3
   rtcastle0altar3 = getTag(e, "rtcastle0altar3")
   if (rtcastle0altar3 == 2):
      altarComplete(e)
   elif (rtcastle0altar3 == 1):
      returnFigure(e)
   else:
      firstVisit(e)
   return 0


def firstVisit(e):
   showMessage(e, ["There is an altar of polished obsidian here.", "", "Upon the altar sits a bone figurine of an old woman."])
   text = ["Will you take the figurine?"]
   optionTexts = ["(Y)es", "(N)o"]
   optionsKeys = [SDLK_y, SDLK_n]
   if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
      giveItems(e, ["Bone Figurine"])
      rtcastle0altar3 = 1
      setTag(e, "rtcastle0altar3", rtcastle0altar3)
      return 0
   else:
      return 0


def returnFigure(e):
   i, max = 0, getPartyCount(e)
   hasFigure = 0
   while (i < max):
      if (hasItem(e, i, "Obsidian Figurine") & (rtcastle0altar3 == 1)):
         hasFigure = 1
         break
      i += 1
   text = ["You approach the obsidian altar."]
   if (hasFigure):
      optionTexts = ["(Y)es", "(N)o"]
      optionsKeys = [SDLK_y, SDLK_n]
      text.extend(["", "The obsidian figurine produces a ringing noise as you approach the altar", "", "Do you place the obsidian figurine upon the altar?"])
   else:
      optionTexts = ["(L)eave the Scene"]
      optionsKeys = [SDLK_l]
   if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
      removeFigure(e)


def removeFigure(e):
   i, max = 0, getPartyCount(e)
   hasFigure = 0
   while (i < max):
      if (hasItem(e, i, "Obsidian Figurine")):
         hasFigure = 1
         break
      i += 1
   removeItem(e, i, "Obsidian Figurine")
   playSpecAudio(e, "Bell_Toll2")
   showMessage(e, ["As you place the obsidian figurine upon the altar, you hear the sound of a bell tolling.", "", "The figurine and altar begin to glow with a soft red light.  A faint ringing sound can be heard."])
   rtcastle0altar3 = 2
   setTag(e, "rtcastle0altar3", rtcastle0altar3)


def altarComplete(e):
   showMessage(e, ["The obsidian figurine and altar glow with a soft red light.  A faint ringing sound can be heard."], optionInput)
   return 0