#Western Castle floor 0 altar 4
from SDLKeys import SDLK_y, SDLK_n, SDLK_l
from eventAPI import *
from APIUtils import *

rtcastle0altar4 = 0

def fireEvent(e):
   global rtcastle0altar4
   rtcastle0altar4 = getTag(e, "rtcastle0altar4")
   if (rtcastle0altar4 == 2):
      altarComplete(e)
   elif (rtcastle0altar4 == 1):
      returnFigure(e)
   else:
      firstVisit(e)
   return 0


def firstVisit(e):
   showMessage(e, ["There is an altar of tarnished silver here.", "", "Upon the altar sits a marble figurine of a young woman."])
   text = ["Will you take the figurine?"]
   optionTexts = ["(Y)es", "(N)o"]
   optionsKeys = [SDLK_y, SDLK_n]
   if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
      giveItems(e, ["Marble Figurine"])
      rtcastle0altar4 = 1
      setTag(e, "rtcastle0altar4", rtcastle0altar4)
      return 0
   else:
      return 0


def returnFigure(e):
   i, max = 0, getPartyCount(e)
   hasFigure = 0
   while (i < max):
      if (hasItem(e, i, "Silver Figurine") & (rtcastle0altar4 == 1)):
         hasFigure = 1
         break
      i += 1
   text = ["You approach the silver altar."]
   if (hasFigure):
      optionTexts = ["(Y)es", "(N)o"]
      optionsKeys = [SDLK_y, SDLK_n]
      text.extend(["", "The silver figurine produces a ringing noise as you approach the altar", "", "Do you place the silver figurine upon the altar?"])
   else:
      optionTexts = ["(L)eave the Scene"]
      optionsKeys = [SDLK_l]
   if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
      removeFigure(e)


def removeFigure(e):
   i, max = 0, getPartyCount(e)
   hasFigure = 0
   while (i < max):
      if (hasItem(e, i, "Silver Figurine")):
         hasFigure = 1
         break
      i += 1
   removeItem(e, i, "Silver Figurine")
   playSpecAudio(e, "Bell_Toll2")
   showMessage(e, ["As you place the silver figurine upon the altar, you hear the sound of a bell tolling.", "", "The figurine and altar begin to glow with a soft white light.  A faint ringing sound can be heard."])
   rtcastle0altar4 = 2
   setTag(e, "rtcastle0altar4", rtcastle0altar4)


def altarComplete(e):
   showMessage(e, ["The silver figurine and altar glow with a soft white light.  A faint ringing sound can be heard."], optionInput)
   return 0