#Captain of the guard of Rennibister
from eventAPI import *
from APIUtils import *

rtDefendFlag1=0

def fireEvent(e):
   global rtDefendFlag1
   rtDefendFlag1 = getTag(e, "rtDefendFlag1")
   if (rtDefendFlag1 == 2):
      returnVisit(e)
   elif (rtDefendFlag1 == 1):
      questDone(e)
   else:
      firstVisit(e)

def firstVisit(e):
   global rtDefendFlag1
   showPicture(e, "Barracks")
   playSpecAudio(e, "Barracks")
   if (rtDefendFlag1 == 0):
      showMessage(e, ["You enter the office of the Captain of the Guard of Rennibister.", "", "The Captain appears busy with paperwork and barely glances at you before speaking in a gruff tone."], optionInput)
      showPicture(e, "Human_Male06")
      showMessage(e, ["\"What is it you need?\"", "", "\"Speak up, I have much to do today and cannot idly wait on you.\""])
      showMessage(e, ["The captain pauses in his work long enough to look you over." , "", "\"Well, we are currently signing up new recruits if that is your business. I'll have Brenard escort you to the commissions office so that...\""])
      showMessage(e, ["Before the captain can finish you hear the sound of bells ringing all over the city."])
      showMessage(e, ["\"Gods! What is it now!\"", "", "\"Brenard! Brenard, where are you?!\"", "", "Behind you a battle hardened guard enters the room."])
      showPicture(e, "Guard_of_Rennibister")
      showMessage(e, ["\"Sir! Reports of goblins marching upon the city! The guard is now assembling at the gates.\""])
      showPicture(e, "Human_Male06")
      showMessage(e, ["The captain's face pales.", "", "\"Such timing they have with half the guard away at Cuween Hill.\"", "", "\"Ask for volunteers among the citizenry. Their necks are in as much danger as ours now.\""])
   else:
      showMessage(e, ["You return to the office of the Captain of the Guard of Rennibister.", "", "He is preparing to respond to the emergency."], optionInput)
      showPicture(e, "Human_Male06")
   if (poseYesNo(e, ["As the captain buckles on his sword he turns towards you.", "", "\"Can we count on you to aid the city in our time of need?\""])):
      setExit(e, "maps/rtRenDefend.cfg", 29, 24, 270)
      return 0
   else:
      showMessage(e, ["\"Cowards! Know that if the city falls, you will not outlive her!\""])
      showPicture(e, "Barracks")
      showMessage(e, ["You leave.", "", "May the Gods grant mercy if the City Guard cannot hold back the invaders."])
      setTag(e, "rtDefendFlag1", 3)
      return 0

def questDone(e):
   showPicture(e, "Barracks")
   playSpecAudio(e, "Barracks")
   partyIdx = 0
   while (partyIdx < getPartyCount(e)):
      modifyHP(e, partyIdx, +2000)
      modifySP(e, partyIdx, +500)
      partyIdx += 1
   showMessage(e, ["You are healed of your wounds and given time to rest in the main guard barracks.", "", "As you are preparing to leave, one of the city guards enters and addresses you."])
   showPicture(e, "Guard_of_Rennibister")
   showMessage(e, ["\"The Captain wishes to see you before you leave.\"", "", "You were hoping to leave before the captain could entangle you in any more city emergencies, but you dutifully follow."])
   showPicture(e, "Barracks")
   showMessage(e, ["As before, you find yourself in the office of the Captain of the Guard of Rennibister."], optionInput)
   showMessage(e, ["The Captain is peering at a map of the city and dicussing plans to repair the damaged wall with the city engineeers.", "", "As you draw close, the Captain looks up and addresses you directly."])
   showPicture(e, "Human_Male06")
   showMessage(e, ["\"We have lost good men today and the city has been damaged, but we will recover.\"", "", "\"With the loss of their battle leader, the goblins will certainly not attack again soon.\""])
   showMessage(e, ["\"Your contribution has not gone unnoticed.\""])
   showMessage(e, ["\"Brenard will give you a small token of the King's appreciation. I wish it were more, but there is much to be done to repair the city and the coffers are not bottomless.\""])
   showMessage(e, ["\"So, might you now be interested in joining with the city guard? The city needs those with strength and courage to help defend her.\"", "", "...", "", "\"Well, if you change your mind, you know where to find us.\""])
   showPicture(e, "Barracks")
   showMessage(e, ["The Captain's secretary, Brenard, appears and hands you a small pouch of gold."])
   showMessage(e, ["You walk out into the city. Already the smoke and stench are beginning to clear. Rennibister and her citizens can rest for now.", "", "Even so, you know that you may be called upon again to protect your home."])
   rtDefendFlag1=2
   setTag(e, "rtDefendFlag1", rtDefendFlag1)
   partyIdx = 0
   while (partyIdx < getPartyCount(e)):
      modifyGold(e, partyIdx, 400)
      partyIdx += 1
   return 0

def returnVisit(e):
   showPicture(e, "Barracks")
   playSpecAudio(e, "Barracks")
   showMessage(e, ["The Captain is far too busy to meet with you now."])
