#hedge guardian
from eventAPI import *
from APIUtils import *

rthedgeFlag = 0

def fireEvent(e):
   global rthedgeFlag
   rthedgeFlag = getTag(e, "rthedgeFlag")
   if (rthedgeFlag == 3):
      openGate(e)
   elif (rthedgeFlag == 2):
      lockedGate(e)
   elif (rthedgeFlag == 1):
      showMessage(e, ["As you approach, the Guardian stirs back to life!"])
      fightThem(e)
   else:
      showMessage(e, ["You come across what appears to be a mound of dirt and leaves.", "", "Suddenly, the mound stirs and takes the form of a giant dragon!"], optionInput)
      fightThem(e)
   return 0

def fightThem(e):
   showPicture(e, "Earth_Dragon")
   showMessage(e, ["\"FOOOOOOOOOD!\""], optionInput)
   combatRet = combat(e, [("Hedge Guardian", 1, 0, 10)])
   if (combatRet == 1):
      wonFight(e)
   elif (combatRet == 3):
      lostFight(e)
   else:
      ranAwayFight(e)

def wonFight(e):
   global rthedgeFlag
   clearPicture(e)
   showMessage(e, ["The beast collapses in a shower of leaves and dirt.  As the air clears, you notice that the creature was originally sitting on top of something."])
   showPicture(e, "Catacombs")
   showMessage(e, ["There appears to be a passage in the ground here.  It barred by a large metal grating.  The bars are still solid and are too thick to break by any means at your disposal."]) 
   showMessage(e, ["You search for a means to open the grate but there is no handle or lock.  Perhaps this cover was bolted into place?  If so, then what is below that all should be barred entry and exit?"])
   rthedgeFlag = 2
   setTag(e, "rthedgeFlag", rthedgeFlag)

def lostFight(e):
   showMessage(e, ["Darkness surrounds you and you suffocate under a pile of dirt and leaves."])

def ranAwayFight(e):
   global rthedgeFlag
   showMessage(e, ["You quickly outrun the slow moving beast."])
   rthedgeFlag = 1
   setTag(e, "rthedgeFlag", rthedgeFlag)

def lockedGate(e):
   global rtetherLordFlag
   rtetherLordFlag = getTag(e, "rtetherLordFlag")
   showPicture(e, "Catacombs")
   showMessage(e, ["There is a large metal grate covering a passage that disappears into the darkness."])
   showMessage(e, ["You search for a means to open the grate but there is no handle or lock.  Perhaps this cover was bolted into place?  If so, then what is below that all should be barred entry and exit?"])
   if (rtetherLordFlag == 2):
      showMessage(e, ["As you run your hands across the edges of the grate you experience a shock that causes you to yell in pain.  A vision of the empty space you visited before fills your mind and you stagger slightly.", "", "The grate swings open."])
      rthedgeFlag = 3
      setTag(e, "rthedgeFlag", rthedgeFlag)
      openGate(e)     

def openGate(e):
   showPicture(e, "Catacombs")
   if (poseYesNo(e, ["You are unable to see where this passage leads.", "", "Do you wish to attempt the climb down into the darkness?"])):
      setExit(e, "maps/rtgallery.cfg", 7, 2, 0)
      return 0
