#Lord of Ether
from eventAPI import *
from APIUtils import *

rtetherLordFlag = 0

def fireEvent(e):
   global rtetherLordFlag
   rtetherLordFlag = getTag(e, "rtetherLordFlag")
   if (rtetherLordFlag == 4):
      return 1
   elif (rtetherLordFlag == 3):
      fightThem1(e)
   elif (rtetherLordFlag == 2):
      lastVisit(e)
   elif (rtetherLordFlag == 1):
      returnVisit(e)
   else:
      firstVisit(e)
   return 0

def firstVisit(e):
   global rtetherLordFlag
   showMessage(e, ["In this vast empty space you come upon a lone figure."], optionInput)
   showPicture(e, "Human_Male03")
   showMessage(e, ["The figure is that of a man who looks human, but from him emenates a strange power."])
   showMessage(e, ["\"It has been long since your kind has stepped through the portal.\"", "", "\"In times past there were many.  But the universe has changed and the fires have grown dim.\""])
   showMessage(e, ["You have no idea what he's talking about."])
   showMessage(e, ["\"So, why have you come?\"", "", "The strange man waits patiently for your answer, but you have none to give."])
   showMessage(e, ["\"Perhaps you are here unintentionally?\"", "", "\"Hmm, yes.  You do not know, do you?  Then perhaps you might help me instead?\""])
   if (poseYesNo(e, ["The man falls silent and waits for your response.", "", "Will you help him?"])):
      yesHelp(e)
   else:
      noHelp(e)

def returnVisit(e):
   showMessage(e, ["You return to the strange man who sits all alone in this place."], optionInput)
   showPicture(e, "Human_Male03")
   showMessage(e, ["\"Why have you returned?\"", "", "\"Are you perhaps wishing to help me after all?\""])
   if (poseYesNo(e, ["The strange man falls silent and waits for your response.", "", "Will you help him?"])):
      yesHelp(e)
   else:
      noHelp(e)

def lastVisit(e):
   rtpillar = 0
   rtpillar = getTag(e, "rtpillar")
   hasHeart = 0
   if (firstHasItem(e, "Elemental Heart") >= 0):
      hasHeart = 1
   showPicture(e, "Human_Male03")
   showMessage(e, ["The strange man looks up at your approach."])
   if (hasHeart):
      giveHeart(e)
   elif (rtpillar > 1):
      giveNothing(e)
   else:
      showMessage(e, ["\"Why have you returned when your task is not yet done?\"", "", "\"Go and complete what you have started.\""])      

def giveHeart(e):
   if (poseYesNo(e, ["\"Yes, I can tell that you have returned with it.\"", "", "\"Now, if you would please hand it over\"", "", "", "Do you give the Elemental Heart to the strange man?"])):
      removeHeart(e)
   else:
      noHelp2(e)

def giveNothing(e):
   showPicture(e, "Human_Male03")
   showMessage(e, ["He rushes forward and grabs you", "", "\"You had it!  You had it and you locked it away!\""])
   showMessage(e, ["Shoving you away the man retreats a few steps.", "", "\"For this insult you will all perish!\""])
   showPicture(e, "Shapeshifter")
   showMessage(e, ["Before your eyes the strange man transforms into a towering figure,", "", "With a wave of his hand several great figures appear beside him."])
   fightThem2(e)

def yesHelp(e):
   showMessage(e, ["The man smiles broadly at you.", "", "\"I knew that you would, I could see it within you.\""])
   showMessage(e, ["The man makes a small gesture with his hands, almost as if he was throwing something at you."])
   showMessage(e, ["\"I have given you the key to a place below the earth.  Within this place there is a pillar of elements and contained within it there is an item of power.\"", "", "\"Find and bring me the item of elemental energy.\""])
   showMessage(e, ["\"Within this place there is also a second pillar.  On this each symbol is a gateway.  This second pillar is the key to the first.\""])
   showMessage(e, ["\"This is not an easy thing that I ask, but you will be rewarded for your effort.\""])
   rtetherLordFlag = 2
   setTag(e, "rtetherLordFlag", rtetherLordFlag)


def noHelp(e):
   showMessage(e, ["The strange man gives a slight shrug.", "", "\"Then neither of us is of use to the other.  You may leave.\""])
   rtetherLordFlag = 1
   setTag(e, "rtetherLordFlag", rtetherLordFlag)


def noHelp2(e):
   showMessage(e, ["The strange man appears angry at your refusal.", "", "\"Fools! Why go through the trouble of obtaining it then?  It is of no use to you!\""])
   showMessage(e, ["\"Return when you have gained ahold of your senses!\""])


def removeHeart(e):
   holder = firstHasItem(e, "Elemental Heart")
   removeItem(e, holder, "Elemental Heart")
   showMessage(e, ["As the strange man takes the object from you he smiles.", "", "\"I have been missing this for a very long time.\""])
   showMessage(e, ["He clasps the Elemental Heart to his chest and the item is absorbed into his body", "", "The strange emenation that you felt the first time you arrived returns, stronger than before."])
   showMessage(e, ["\"Fools that had taken it from me and fools again that returned it.\"", "", "\"I have matters to attend to. Begone before I tire of your presence.\""]) 
   rtetherLordFlag = 3
   setTag(e, "rtetherLordFlag", rtetherLordFlag)


def fightThem1(e):
   showMessage(e, ["You approach the fool man to give him a piece of you mind.", "", "As you draw near, he angrily turns to you."])
   showPicture(e, "Human_Male03")
   showMessage(e, ["\"Fools to the end.  I gave you a chance to continue your path and yet you fail to grasp that which stands before you.\""])
   showPicture(e, "Shapeshifter")
   showMessage(e, ["The man is now gone and a towering figure is in his place.  Odd, but you did not see a transformation of any sort."])
   showMessage(e, ["\"This world is mine and you shall be the first to fall by my sword!\""])
   showMessage(e, ["With a wave of his hand, the figure summons his minions to attack you."])
   combatRet = combat(e, [("Servant of Fire", 3, 0, 10),("Thirster", 3, 0, 10), ("Stone Beast", 3, 0, 10), ("Twister", 3, 0, 10)])
   if (combatRet == 1):
      showPicture(e, "Shapeshifter")
      showMessage(e, ["\"Impressive, but not enough.\"", "", "The titan again summons a host of creatures to fight you."])
      fightThem2(e)
   elif (combatRet == 3):
      lostFight(e)
   else:
      ranAwayFight(e)

def fightThem2(e):
   combatRet = combat(e, [("Titan of Aether", 1, 0, 10), ("Dread Knight", 1, 0, 10), ("Basilisk", 1, 0, 10), ("Kraken", 1, 0, 10)])
   if (combatRet == 1):
      wonFight(e)
   elif (combatRet == 3):
      lostFight(e)
   else:
      ranAwayFight(e)

def wonFight(e):
   showMessage(e, ["With your final blow, the titan falls to its knees and then fades away."])
   clearPicture(e)
   showMessage(e, ["A voice behind you suddenly speaks.", "", "\"You have a strength and skill that I have not witnessed for an age.\""])
   showPicture(e, "Human_Male03")
   showMessage(e, ["You turn to find the strange man as he was before."])
   showMessage(e, ["\"I am defeated... for now.\"", "", "\"My time will come again and who will stop me then?\""])
   showMessage(e, ["You rush towards the man, but he fades away before you can reach him.", "", "You have stopped him for now, but it was you who almost unleashed him."])
   rtetherLordFlag = 4
   setTag(e, "rtetherLordFlag", rtetherLordFlag)

def lostFight(e):
   rtpillar = 0
   rtpillar = getTag(e, "rtpillar")
   if (rtpillar > 1):
     showMessage(e, ["You hear a voice as your conciousness fades."])
     showMessage(e, ["\"Time I have, and there will always be another who will bring me what I need.\""])
   else:
     showMessage(e, ["You hear a voice as your conciousness fades."])
     showMessage(e, ["\"All shall kneel before me willingly or they shall fall.  This world is mine!\""])
     showMessage(e, ["what evil have you unleashed?"])

def ranAwayFight(e):
   showMessage(e, ["As you turn to flee, the titan strikes at your back.  You are felled with a single great strike."])
   partyIdx = 0
   while (partyIdx < getPartyCount(e)):
      modifyHP(e, partyIdx, -50000)
      partyIdx += 1
   lostFight(e)
