#plane of fire tree
from eventAPI import *
from APIUtils import *

rtpofireTree=0

def fireEvent(e):
   global rtpofireTree
   rtpofireTree = getTag(e, "rtpofireTree")
   if (rtpofireTree == 4):
      return 1
   elif ((rtpofireTree == 2) or (rtpofireTree == 3)):
      giveWater2(e)
   elif (rtpofireTree == 1):
      returnVisit(e)
   else:
      blackwood(e)

def blackwood(e):
   showMessage(e, ["Alone amoung the scorching pools of lava you find a massive tree.  The bark is blackened and no leaves adorn the branches, but the roots seem to hold fast to the rocky ground.  You wonder how such a massive tree had grown in such an inhospitable area."])
   showMessage(e, ["As you draw closer, the branches move as though stirred by a breeze.  Suddenly a pair of eyes appear on the trunk and roll in your direction.  You quickly stumble backwards away from the creature."])
   showPicture(e, "Darcwood")
   showMessage(e, ["\"Stand and fight, braggart!  Bring your fires, for they can no longer harm me!\"", "", "You quickly move away from the swaying branches and the creature seems unable to pursue you."])
   showMessage(e, ["The tree gives pause and studies you closely", "", "\"Oh, my apologies.  I thought you were those bothersome imps come to set me alight again.\""])
   showMessage(e, ["\"I am Sir Blackwood, Knight of the Spring.  Vassal of the Lord Wind.  It was he who knighted me following the War of the Great Drought.\"", "", "The tree creaks as it attempts a bow.  The branches sway and settle back into place."])
   showMessage(e, ["\"My lord, Wind, has been trapped by that hothead, Flame.  I cannot allow this injustice to go unpunished, so I have set out to force his release.\""])
   showMessage(e, ["\"The tricks and traps of this place are numerous and I have not been able to fight past the barrier of flame.  Still, I have faced all that have come against me and triumphed!\""])
   showMessage(e, ["ahem", "", "\"Of course, this place is very dry and I have been stuck here for some time.  Do you, perhaps, have a bit of water?  Just a bit to, ah, quench my thirst?\""])
   rtpofireTree=1
   setTag(e, "rtpofireTree", rtpofireTree)
   if (poseYesNo(e, ["Will you give Sir Blackwood some water?"])):
      giveWater(e)
   else:
      showMessage(e, ["\"Of course.  You are busy and so am I.  Be stalwart on your journey and fear not the flames.\""])

def returnVisit(e):
   showPicture(e, "Darcwood")
   if (poseYesNo(e, ["As you approach Sir Blackwood, he addresses you with a dry, scratchy voice", "", "\"Do you, perhaps, have a bit of water?  Just a bit to, ah, quench my thirst?\"", "", "Will you give Sir Blackwood some water?"])):
      giveWater(e)
   else:
      showMessage(e, ["\"Of course.  You are busy and so am I.  Be stalwart on your journey and fear not the flames.\""])

def giveWater(e):
   showMessage(e, ["You pour some water at the base of the tree.  The water quickly disappears into the dry ash.", "", "\"Ah, thank you!  Very refreshing!\""])
   if (poseYesNo(e, ["\"I appreciate your kindness, but perhaps you are willing to obtain something a bit more potent?\""])):
      showMessage(e, ["\"Go to the realm of Ocean.  There you will find a pool of the clearest water.  Bring back as much of the water as you can carry.\""])
      rtpofireTree=2
      setTag(e, "rtpofireTree", rtpofireTree)
   else:
      showMessage(e, ["\"Of course.  You are busy and so am I.  Be stalwart on your journey and fear not the flames.\""])


def giveWater2(e):
   showPicture(e, "Darcwood")
   text = ["\"Greetings again travelers.  Do you, perhaps, have a bit of water?  Just a bit to, ah, quench my thirst?\""]
   if (rtpofireTree == 3):
      optionTexts = ["(Y)es", "(N)o"]
      optionsKeys = [SDLK_y, SDLK_n]
      text.extend(["", "Will you give the water from the Plane of Water to Sir Blackwood?"])
      if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
         blackwoodRevived(e)
   else:
      optionTexts = ["(Y)es", "(N)o"]
      optionsKeys = [SDLK_y, SDLK_n]
      text.extend(["", "Will you give Sir Blackwood some water?"])
      if (optionInput(e, text, optionTexts, optionsKeys) == SDLK_y):
         showMessage(e, ["You pour some water at the base of the tree.  The water quickly disappears into the dry ash.", "", "\"Ah, thank you!  Very refreshing!\"", "", "\"Go now and show the minions of Flame that they will receive no mercy from the likes of us!  Ho Ho!\""])


def blackwoodRevived(e):
   showPicture(e, "Darcwood")
   showMessage(e, ["You empty every drop of the cool water onto the ash where it is quickly absorbed into the ground.  Sir Blackwood, however, seems very pleased."])
   showMessage(e, ["\"Remarkable!\"", "", "\"Glorious!", "", "\"Wonderful to taste such waters again!\""])
   showMessage(e, ["Sir Blackwood sways his branches.", "", "\"Soon, I will be able to move from this dreaded spot once again!  And when I am able, I will go forth to conquer Flame!  Ho Ho!\""])
   showMessage(e, ["\"Listen, traveler.  Go to the farthest edge there to the west and dig.  There you will find a staff of wood that was made by the Lord Wind himself from the remains of Sir Redwood, greatest of the trees.  He was slain in battle against the Dark Clan, but his spirit is such that even now he will grant those that wield redwood weapons his strength.\""])
   showMessage(e, ["\"I'm afraid that I had to hide it due to my becoming incapacitated, but it is now yours.\""])
   showMessage(e, ["Sir Blackwood stretches his roots deep into the ground and straigtens out his limbs.", "", "\"I will recover now.  Yes, soon, I will march forth from this spot.\""])
   showMessage(e, ["Sir Blackwood now seems to be nothing more than an ordinary tree, but amoung his branches there are small green buds", "", "Soon, he will indeed recover."])
   rtpofireTree = 4
   setTag(e, "rtpofireTree", rtpofireTree)
