# generated by wxGlade 0.2.3 on Sat Jul 12 21:46:28 2003

from wxPython.wx import *

# begin wxGlade: dependencies
# end wxGlade

import ActionFile
from ActionConfigDialog import ActionConfigDialog

class ActionEditor(wxFrame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: ActionEditor.__init__
        kwds["style"] = wxDEFAULT_FRAME_STYLE
        wxFrame.__init__(self, *args, **kwds)
        
        # Menu Bar
        self.ActionEditor_menubar = wxMenuBar()
        self.SetMenuBar(self.ActionEditor_menubar)
        wxglade_tmp_menu = wxMenu()
        wxglade_tmp_menu.Append(2001, "&Open\tCtrl-O", "Open an Action File")
        wxglade_tmp_menu.Append(2002, "&Save\tCtrl-S", "Save the Action File")
        wxglade_tmp_menu.Append(2003, "Save &As...\tShift-Ctrl-S", "Save the Action List under a new name")
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(2004, "&Quit\tAlt-F4", "Quit the Editor")
        self.ActionEditor_menubar.Append(wxglade_tmp_menu, "&File")
        wxglade_tmp_menu = wxMenu()
        wxglade_tmp_menu.Append(2101, "&Add Action\tCtrl-A", "Add an Action")
        wxglade_tmp_menu.Append(2102, "&Remove Action\tCtrl-R", "Remove the selected Action")
        wxglade_tmp_menu.Append(2103, "&Edit Action\tCtrl-E", "Edit the selected Action")
        self.ActionEditor_menubar.Append(wxglade_tmp_menu, "&Action")
        # Menu Bar end
        self.ActionEditor_statusbar = self.CreateStatusBar(1)
        self.actionList = wxListCtrl(self, 1301, size=(-1,200), style=wxLC_REPORT|wxLC_SINGLE_SEL|wxSUNKEN_BORDER)
        self.label_48 = wxStaticText(self, -1, "Filters...")
        self.skillBox = wxCheckBox(self, -1, "Skills")
        self.spellBox = wxCheckBox(self, -1, "Spells")
        self.label_49 = wxStaticText(self, -1, "Valid Classes (Must match *at least* one)")
        self.barbarianBox = wxCheckBox(self, -1, "Barbarian")
        self.redClawBox = wxCheckBox(self, -1, "Red Claw")
        self.warriorBox = wxCheckBox(self, -1, "Warrior")
        self.paladinBox = wxCheckBox(self, -1, "Paladin")
        self.psiKnightBox = wxCheckBox(self, -1, "Psi Knight")
        self.monkBox = wxCheckBox(self, -1, "Monk")
        self.rangerBox = wxCheckBox(self, -1, "Ranger")
        self.bardBox = wxCheckBox(self, -1, "Bard")
        self.rogueBox = wxCheckBox(self, -1, "Rogue")
        self.arcanistBox = wxCheckBox(self, 1302, "Arcanist")
        self.geomancerBox = wxCheckBox(self, -1, "Geomancer")
        self.aeromancerBox = wxCheckBox(self, -1, "Aeromancer")
        self.hydromancerBox = wxCheckBox(self, -1, "Hydromancer")
        self.pyromancerBox = wxCheckBox(self, -1, "Pyromancer")
        self.isomancerBox = wxCheckBox(self, -1, "Isomancer")
        self.panel_2 = wxPanel(self, -1)
        self.label_50 = wxStaticText(self, -1, "Path (if Arcanist selected)")
        self.magicianBox = wxCheckBox(self, -1, "Magician")
        self.thaumBox = wxCheckBox(self, -1, "Thaumaturgist")
        self.illusionBox = wxCheckBox(self, -1, "Illusionist")
        self.summonBox = wxCheckBox(self, -1, "Summoner")
        self.warlockBox = wxCheckBox(self, -1, "Warlock")
        self.panel_3 = wxPanel(self, -1)
        self.applyButton = wxButton(self, 1303, "Apply")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

        self.initLocals()
        self.RegisterEvents()

    def __set_properties(self):
        # begin wxGlade: ActionEditor.__set_properties
        self.SetTitle("Action Editor")
#        self.SetBackgroundColour(wxColour(212, 208, 200))
        self.SetBackgroundColour(wxLIGHT_GREY)
        self.ActionEditor_statusbar.SetStatusWidths([-1])
        # statusbar fields
        ActionEditor_statusbar_fields = [""]
        for i in range(len(ActionEditor_statusbar_fields)):
            self.ActionEditor_statusbar.SetStatusText(ActionEditor_statusbar_fields[i], i)
        self.label_48.SetBackgroundColour(wxLIGHT_GREY)
        self.label_49.SetBackgroundColour(wxLIGHT_GREY)
        self.label_50.SetBackgroundColour(wxLIGHT_GREY)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: ActionEditor.__do_layout
        sizer_41 = wxBoxSizer(wxVERTICAL)
        sizer_42 = wxBoxSizer(wxVERTICAL)
        grid_sizer_6 = wxGridSizer(2, 3, 5, 5)
        grid_sizer_3_copy = wxGridSizer(4, 4, 5, 5)
        sizer_44 = wxBoxSizer(wxHORIZONTAL)
        sizer_43 = wxBoxSizer(wxHORIZONTAL)
        sizer_42.Add(self.actionList, 1, wxEXPAND, 0)
        sizer_42.Add(self.label_48, 0, wxLEFT|wxRIGHT|wxBOTTOM, 5)
        sizer_43.Add(self.skillBox, 1, wxRIGHT|wxALIGN_CENTER_VERTICAL, 10)
        sizer_43.Add(self.spellBox, 1, wxALIGN_CENTER_VERTICAL, 0)
        sizer_42.Add(sizer_43, 0, wxALL|wxEXPAND, 5)
        sizer_44.Add(self.label_49, 0, 0, 0)
        sizer_42.Add(sizer_44, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        grid_sizer_3_copy.Add(self.barbarianBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.redClawBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.warriorBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.paladinBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.psiKnightBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.monkBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.rangerBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.bardBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.rogueBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.arcanistBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.geomancerBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.aeromancerBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.hydromancerBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.pyromancerBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.isomancerBox, 0, wxEXPAND, 0)
        grid_sizer_3_copy.Add(self.panel_2, 0, 0, 0)
        sizer_42.Add(grid_sizer_3_copy, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_42.Add(self.label_50, 0, wxLEFT|wxRIGHT|wxBOTTOM, 5)
        grid_sizer_6.Add(self.magicianBox, 0, 0, 0)
        grid_sizer_6.Add(self.thaumBox, 0, 0, 0)
        grid_sizer_6.Add(self.illusionBox, 0, 0, 0)
        grid_sizer_6.Add(self.summonBox, 0, 0, 0)
        grid_sizer_6.Add(self.warlockBox, 0, 0, 0)
        grid_sizer_6.Add(self.panel_3, 0, 0, 0)
        sizer_42.Add(grid_sizer_6, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_42.Add(self.applyButton, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_41.Add(sizer_42, 1, wxEXPAND, 0)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_41)
        sizer_41.Fit(self)
        sizer_41.SetSizeHints(self)
        self.Layout()
        # end wxGlade

    def initLocals(self):
        self.Filter={"Skills":1,
                     "Spells":1,
                     "validClasses":0xffffffff,
                     "paths":0xffffffff
                     };
        self.listActions=[]
        self.filename=None;

        self.skillBox.SetValue(1);
        self.spellBox.SetValue(1);
        self.barbarianBox.SetValue(1);
        self.redClawBox.SetValue(1);
        self.warriorBox.SetValue(1);
        self.paladinBox.SetValue(1);
        self.psiKnightBox.SetValue(1);
        self.monkBox.SetValue(1);
        self.rangerBox.SetValue(1);
        self.bardBox.SetValue(1);
        self.rogueBox.SetValue(1);
        self.arcanistBox.SetValue(1);
        self.geomancerBox.SetValue(1);
        self.aeromancerBox.SetValue(1);
        self.hydromancerBox.SetValue(1);
        self.pyromancerBox.SetValue(1);
        self.isomancerBox.SetValue(1);
        self.magicianBox.SetValue(1);
        self.thaumBox.SetValue(1);
        self.illusionBox.SetValue(1);
        self.summonBox.SetValue(1);
        self.warlockBox.SetValue(1);

        self.newNum=0x00002000;

        self.UpdateDisplay();

    def RegisterEvents(self):
        EVT_MENU(self,2001,self.OnOpen);
        EVT_MENU(self,2002,self.OnSave);
        EVT_MENU(self,2003,self.OnSaveAs);
        EVT_MENU(self,2004,self.OnQuit);

        EVT_MENU(self,2101,self.OnAdd);
        EVT_MENU(self,2102,self.OnRemove);
        EVT_MENU(self,2103,self.OnEdit);

        EVT_LIST_ITEM_ACTIVATED(self,1301,self.OnEdit);

        EVT_CHECKBOX(self,1302,self.OnArcanist);

        EVT_BUTTON(self,1303,self.OnApply);

    def OnOpen(self,evt):
        wildcard = "Action Lists (*.dat)|*.dat|All Files (*.*)|*.*"
        dlg=wxFileDialog(self,"Choose a file","","",wildcard,wxOPEN);
        if dlg.ShowModal()==wxID_OK:
            self.filename=dlg.GetPath();
            self.listActions=ActionFile.LoadActions(self.filename);
        dlg.Destroy();
        self.UpdateDisplay();

    def OnSave(self,evt):
        if self.filename:
            ActionFile.SaveActions(self.filename,self.listActions);

    def OnSaveAs(self,evt):
        wildcard = "Action Lists (*.dat)|*.dat|All Files (*.*)|*.*"
        dlg=wxFileDialog(self,"Choose a file","","",wildcard,wxSAVE);
        if dlg.ShowModal()==wxID_OK:
            self.filename=dlg.GetPath();
            ActionFile.SaveActions(self.filename,self.listActions);
        dlg.Destroy();

    def OnAdd(self,evt):
        dlg=ActionConfigDialog(self,-1,"Action Configuration",style=wxDEFAULT_DIALOG_STYLE);
        dlg.InitNewAction(self.newNum);
        if dlg.ShowModal()==wxID_OK:
            self.listActions.append(dlg.GetAction());
            self.newNum+=1;
        dlg.Destroy();
        self.UpdateDisplay();

    def OnRemove(self,evt):
        newlist=[];
        idx=self.actionList.GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
        if idx < 0:
            return

        id=self.actionList.GetItem(idx,3).GetText();
        for action in self.listActions:
            if not(id=="0x%08x"%(action["Header"].actionID)):
                newlist.append(action);

        self.listActions=newlist;
        self.UpdateDisplay()

    def OnEdit(self,evt):
        idx=self.actionList.GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
        if idx < 0:
            return

        id=self.actionList.GetItem(idx,3).GetText();
        editAct=None;
        i=-1;
        for i in range(0,len(self.listActions)):
            if id=="0x%08x"%(self.listActions[i]["Header"].actionID):
                editActIndex=i;

        if i>=0:
            dlg=ActionConfigDialog(self,-1,"Action Configuration",style=wxDEFAULT_DIALOG_STYLE);
            dlg.InitAction(self.listActions[editActIndex]);
            if dlg.ShowModal()==wxID_OK:
                self.listActions[editActIndex]=dlg.GetAction();
            dlg.Destroy();

        self.UpdateDisplay();

    def OnQuit(self,evt):
        self.Close();

    def OnArcanist(self,evt):
        if self.arcanistBox.GetValue():
            self.magicianBox.Enable(1);
            self.thaumBox.Enable(1);
            self.illusionBox.Enable(1);
            self.summonBox.Enable(1);
            self.warlockBox.Enable(1);
        else:
            self.magicianBox.Enable(0);
            self.thaumBox.Enable(0);
            self.illusionBox.Enable(0);
            self.summonBox.Enable(0);
            self.warlockBox.Enable(0);

    def OnApply(self,evt):
        self.Filter["Skills"]=self.skillBox.GetValue();
        self.Filter["Spells"]=self.spellBox.GetValue();
        self.Filter["validClasses"]=0x00000000;
        if self.barbarianBox.GetValue():
            self.Filter["validClasses"]|=0x00000001;
        if self.redClawBox.GetValue():
            self.Filter["validClasses"]|=0x00004000;
        if self.warriorBox.GetValue():
            self.Filter["validClasses"]|=0x00000004;
        if self.paladinBox.GetValue():
            self.Filter["validClasses"]|=0x00000020;
        if self.psiKnightBox.GetValue():
            self.Filter["validClasses"]|=0x00000010;
        if self.monkBox.GetValue():
            self.Filter["validClasses"]|=0x00000008;
        if self.rangerBox.GetValue():
            self.Filter["validClasses"]|=0x00000040;
        if self.bardBox.GetValue():
            self.Filter["validClasses"]|=0x00000002;
        if self.rogueBox.GetValue():
            self.Filter["validClasses"]|=0x00000080;
        if self.arcanistBox.GetValue():
            self.Filter["validClasses"]|=0x00000100;
        if self.geomancerBox.GetValue():
            self.Filter["validClasses"]|=0x00000200;
        if self.hydromancerBox.GetValue():
            self.Filter["validClasses"]|=0x00000400;
        if self.aeromancerBox.GetValue():
            self.Filter["validClasses"]|=0x00000800;
        if self.pyromancerBox.GetValue():
            self.Filter["validClasses"]|=0x00001000;
        if self.isomancerBox.GetValue():
            self.Filter["validClasses"]|=0x00002000;

        if self.arcanistBox.GetValue():
            self.Filter["paths"]=0x00000000
            if self.magicianBox.GetValue():
                self.Filter["paths"]|=0x00000001;
            if self.thaumBox.GetValue():
                self.Filter["paths"]|=0x00000002;
            if self.illusionBox.GetValue():
                self.Filter["paths"]|=0x00000004;
            if self.summonBox.GetValue():
                self.Filter["paths"]|=0x00000008;
            if self.warlockBox.GetValue():
                self.Filter["paths"]|=0x00000010;
        else:
            self.Filter["paths"]=0xffffffff;

        self.UpdateDisplay();

    def FilterActions(self):
        retList=[]
        for action in self.listActions:
            if (action["Header"].actionID&0x0000ffff) >= self.newNum:
                self.newNum=(action["Header"].actionID&0x0000ffff)+1;
            if ((self.Filter["Skills"] and (action["Header"].actionType==1)) or
                (self.Filter["Spells"] and (action["Header"].actionType==2))):
                if (((self.Filter["validClasses"] & action["Header"].validClasses) and
                     ((action["Header"].spellPath==0) or
                      ((self.Filter["paths"] & 0x00000001) and (action["Header"].spellPath==1)) or
                      ((self.Filter["paths"] & 0x00000002) and (action["Header"].spellPath==2)) or
                      ((self.Filter["paths"] & 0x00000004) and (action["Header"].spellPath==3)) or
                      ((self.Filter["paths"] & 0x00000008) and (action["Header"].spellPath==4)) or
                      ((self.Filter["paths"] & 0x00000010) and (action["Header"].spellPath==5)))) or
                    (action["Header"].validClasses==0)):
                  retList.append(action);

        return retList

    def UpdateDisplay(self):
        filterActions=self.FilterActions();

        self.actionList.ClearAll();
        self.actionList.InsertColumn(0,"Name");
        self.actionList.InsertColumn(1,"Type");
        self.actionList.InsertColumn(2,"Level");
        self.actionList.InsertColumn(3,"ActionID");
        
        for i in range(0,len(filterActions)):
            self.actionList.InsertStringItem(i,filterActions[i]["Header"].name);
            if filterActions[i]["Header"].actionType==1:
                self.actionList.SetStringItem(i,1,"Skill")
            elif filterActions[i]["Header"].actionType==2:
                self.actionList.SetStringItem(i,1,"Spell")
            else:
                self.actionList.SetStringItem(i,1,"Other")
            self.actionList.SetStringItem(i,2,"%d"%(filterActions[i]["Header"].levelAcquired));
            self.actionList.SetStringItem(i,3,"0x%08x"%(filterActions[i]["Header"].actionID));

        if self.arcanistBox.GetValue():
            self.magicianBox.Enable(1);
            self.thaumBox.Enable(1);
            self.illusionBox.Enable(1);
            self.summonBox.Enable(1);
            self.warlockBox.Enable(1);
        else:
            self.magicianBox.Enable(0);
            self.thaumBox.Enable(0);
            self.illusionBox.Enable(0);
            self.summonBox.Enable(0);
            self.warlockBox.Enable(0);

# end of class ActionEditor


class MyApp(wxApp):
    def OnInit(self):
        self.main=ActionEditor(None,-1,"Action Editor");
        self.main.Show()
        return true;

if __name__=="__main__":
    app=MyApp()
    app.MainLoop()
