import bl3dGenericActionLoader

def LoadActions(filename):
    file=bl3dGenericActionLoader.bl3dGenericOpen(filename,0);
    retActions=[]
    while not bl3dGenericActionLoader.bl3dGenericEOF(file):
        retActions.append({});
        retActions[-1]["Header"]=bl3dGenericActionLoader.bl3dGeneric_Action_Header();
        retActions[-1]["Header"].read(file);
        print "Just read action 0x%08x..."%(retActions[-1]["Header"].actionID);
        retActions[-1]["Effects"]=[];
        errorFlag=0;
        for i in range(0,retActions[-1]["Header"].numDetails):
            retActions[-1]["Effects"].append({});
            retActions[-1]["Effects"][-1]["Header"]=bl3dGenericActionLoader.bl3dGeneric_Action_Detail_Header();
            retActions[-1]["Effects"][-1]["Header"].read(file);
            if retActions[-1]["Effects"][-1]["Header"].type==bl3dGenericActionLoader.BL3D_GENERIC_ACTION_DAMAGE:
                retActions[-1]["Effects"][-1]["Details"]=bl3dGenericActionLoader.bl3dGeneric_Damage_Details();
                retActions[-1]["Effects"][-1]["Details"].read(file);
            elif retActions[-1]["Effects"][-1]["Header"].type==bl3dGenericActionLoader.BL3D_GENERIC_ACTION_HEALING:
                retActions[-1]["Effects"][-1]["Details"]=bl3dGenericActionLoader.bl3dGeneric_Healing_Details();
                retActions[-1]["Effects"][-1]["Details"].read(file);
            elif retActions[-1]["Effects"][-1]["Header"].type==bl3dGenericActionLoader.BL3D_GENERIC_ACTION_STATMOD:
                retActions[-1]["Effects"][-1]["Details"]=bl3dGenericActionLoader.bl3dGeneric_StatMod_Details();
                retActions[-1]["Effects"][-1]["Details"].read(file);
                retActions[-1]["Effects"][-1]["Mods"]=[];
                for j in range(0,retActions[-1]["Effects"][-1]["Details"].numStatMods):
                    retActions[-1]["Effects"][-1]["Mods"].append(bl3dGenericActionLoader.bl3dGeneric_StatMod_Stat_Details());
                    retActions[-1]["Effects"][-1]["Mods"][-1].read(file);
            else:
                print "ERROR: Unknown type (%d)!!"%(retActions[-1]["Effects"][-1]["Header"].type)
                print "Skipping %d bytes...\n"%(retActions[-1]["Effects"][-1]["Header"].length);
                bl3dGenericActionLoader.bl3dGenericSeek(file,retActions[-1]["Effects"][-1]["Header"].length);
                errorFlag=1;
        if errorFlag:
            print "About to discard action 0x%08x!"%(retActions[-1]["Header"].actionID);
            retActions=retActions[:-1];

    bl3dGenericActionLoader.bl3dGenericClose(file);
    return retActions;

def SaveActions(filename,actionList):
    file=bl3dGenericActionLoader.bl3dGenericOpen(filename,1);
    for action in actionList:
        print "About to write action 0x%08x"%(action["Header"].actionID);
        action["Header"].write(file);
        for effect in action["Effects"]:
            print "\t0x%08x (effect type %d len %d)"%(action["Header"].actionID,effect["Header"].type,effect["Header"].length)
            effect["Header"].write(file);
            effect["Details"].write(file);
            if effect["Header"].type==bl3dGenericActionLoader.BL3D_GENERIC_ACTION_STATMOD:
                for mod in effect["Mods"]:
                    mod.write(file);

    bl3dGenericActionLoader.bl3dGenericClose(file);
