# generated by wxGlade 0.2.3 on Sat Jul 12 21:46:28 2003

from wxPython.wx import *

# begin wxGlade: dependencies
# end wxGlade

import bl3dGenericActionLoader

class HealingDialog(wxDialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: HealingDialog.__init__
        kwds["style"] = wxDEFAULT_DIALOG_STYLE
        wxDialog.__init__(self, *args, **kwds)
        self.label_42 = wxStaticText(self, -1, "Amount:")
        self.diceSpin = wxSpinCtrl(self, -1, "0", min=0, max=1000, style=wxSP_ARROW_KEYS)
        self.label_43 = wxStaticText(self, -1, " d ")
        self.dieSpin = wxSpinCtrl(self, -1, "1", min=1, max=10000, style=wxSP_ARROW_KEYS)
        self.label_44 = wxStaticText(self, -1, " + ")
        self.baseSpin = wxSpinCtrl(self, -1, "0", min=0, max=32000, style=wxSP_ARROW_KEYS)
        self.label_45 = wxStaticText(self, -1, "Target Type")
        self.targetCombo = wxComboBox(self, -1, choices=["Single", "Group", "All", "Player", "Party", "Self"], style=wxCB_DROPDOWN|wxCB_READONLY)
        self.label_46 = wxStaticText(self, -1, "Saving Throw Type")
        self.saveCombo = wxComboBox(self, -1, choices=["None", "Paralization/Poison/Death", "Staff/Wand", "Stoning/Polymorph", "Breath/Spells", "Psionics"], style=wxCB_DROPDOWN|wxCB_READONLY)
        self.label_47 = wxStaticText(self, -1, "Special Conditions:")
        self.resurrectBox = wxCheckBox(self, -1, "Resurrection")
        self.poisonBox = wxCheckBox(self, -1, "Poison")
        self.agedBox = wxCheckBox(self, -1, "Aged")
        self.stunnedBox = wxCheckBox(self, -1, "Stunned")
        self.blindBox = wxCheckBox(self, -1, "Blinded")
        self.witheredBox = wxCheckBox(self, -1, "Withered")
        self.sleepBox = wxCheckBox(self, -1, "Sleeping")
        self.stoneBox = wxCheckBox(self, -1, "Stone")
        self.okButton = wxButton(self, wxID_OK, "OK")
        self.cancelButton = wxButton(self, wxID_CANCEL, "Cancel")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: HealingDialog.__set_properties
        self.SetTitle("Healing Configuration")
        self.targetCombo.SetSelection(0)
        self.saveCombo.SetSelection(0)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: HealingDialog.__do_layout
        sizer_37 = wxBoxSizer(wxVERTICAL)
        sizer_40 = wxBoxSizer(wxHORIZONTAL)
        grid_sizer_5 = wxGridSizer(3, 3, 5, 5)
        sizer_39 = wxBoxSizer(wxHORIZONTAL)
        sizer_38 = wxBoxSizer(wxHORIZONTAL)
        sizer_38.Add(self.label_42, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_38.Add(self.diceSpin, 1, wxRIGHT, 5)
        sizer_38.Add(self.label_43, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_38.Add(self.dieSpin, 1, wxRIGHT, 5)
        sizer_38.Add(self.label_44, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_38.Add(self.baseSpin, 1, 0, 0)
        sizer_37.Add(sizer_38, 0, wxALL|wxEXPAND, 5)
        sizer_39.Add(self.label_45, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_39.Add(self.targetCombo, 1, wxRIGHT, 10)
        sizer_39.Add(self.label_46, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_39.Add(self.saveCombo, 1, 0, 0)
        sizer_37.Add(sizer_39, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_37.Add(self.label_47, 0, wxLEFT|wxRIGHT|wxBOTTOM, 5)
        grid_sizer_5.Add(self.resurrectBox, 0, 0, 0)
        grid_sizer_5.Add(self.poisonBox, 0, 0, 0)
        grid_sizer_5.Add(self.agedBox, 0, 0, 0)
        grid_sizer_5.Add(self.stunnedBox, 0, 0, 0)
        grid_sizer_5.Add(self.blindBox, 0, 0, 0)
        grid_sizer_5.Add(self.witheredBox, 0, 0, 0)
        grid_sizer_5.Add(self.sleepBox, 0, 0, 0)
        grid_sizer_5.Add(self.stoneBox, 0, 0, 0)
        sizer_37.Add(grid_sizer_5, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_40.Add(self.okButton, 1, wxRIGHT|wxEXPAND, 5)
        sizer_40.Add(self.cancelButton, 1, wxEXPAND, 0)
        sizer_37.Add(sizer_40, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_37)
        sizer_37.Fit(self)
        sizer_37.SetSizeHints(self)
        self.Layout()
        # end wxGlade

    def InitNewEffect(self):
        pass

    def InitEffect(self,effectIn):
        if effectIn["Details"].targetSize & 0x01:
            self.targetCombo.SetValue("Single");
        if effectIn["Details"].targetSize & 0x02:
            self.targetCombo.SetValue("Group");
        if effectIn["Details"].targetSize & 0x04:
            self.targetCombo.SetValue("All");
        if effectIn["Details"].targetSize & 0x08:
            self.targetCombo.SetValue("Player");
        if effectIn["Details"].targetSize & 0x10:
            self.targetCombo.SetValue("Party");
        if effectIn["Details"].targetSize & 0x20:
            self.targetCombo.SetValue("Self");

        self.diceSpin.SetValue(effectIn["Details"].numDice);
        self.dieSpin.SetValue(effectIn["Details"].numSides);
        self.baseSpin.SetValue(effectIn["Details"].base);

        if effectIn["Details"].saveType==0:
            self.saveCombo.SetValue("None");
        elif effectIn["Details"].saveType==1:
            self.saveCombo.SetValue("Paralization/Poison/Death");
        elif effectIn["Details"].saveType==2:
            self.saveCombo.SetValue("Staff/Wand");
        elif effectIn["Details"].saveType==3:
            self.saveCombo.SetValue("Stoning/Polymorph");
        elif effectIn["Details"].saveType==4:
            self.saveCombo.SetValue("Breath/Spells");
        elif effectIn["Details"].saveType==5:
            self.saveCombo.SetValue("Psionics");
        else:
            self.saveCombo.SetValue("None");

        if effectIn["Details"].flagSpecial&0x00000001:
            self.resurrectBox.SetValue(1);
        if effectIn["Details"].flagCondition&0x00000001:
            self.stunnedBox.SetValue(1);
        if effectIn["Details"].flagCondition&0x00000002:
            self.poisonBox.SetValue(1);
        if effectIn["Details"].flagCondition&0x00000004:
            self.agedBox.SetValue(1);
        if effectIn["Details"].flagCondition&0x00000008:
            self.sleepBox.SetValue(1);
        if effectIn["Details"].flagCondition&0x00000010:
            self.blindBox.SetValue(1);
        if effectIn["Details"].flagCondition&0x00000080:
            self.witheredBox.SetValue(1);
        if effectIn["Details"].flagCondition&0x00000100:
            self.stoneBox.SetValue(1);

    def GetEffect(self):
        effectOut={};
        effectOut["Header"]=bl3dGenericActionLoader.bl3dGeneric_Action_Detail_Header();
        effectOut["Details"]=bl3dGenericActionLoader.bl3dGeneric_Healing_Details()
        effectOut["Header"].type=bl3dGenericActionLoader.BL3D_GENERIC_ACTION_HEALING;
        effectOut["Header"].length=18;

        if self.targetCombo.GetValue()=="Single":
            effectOut["Details"].targetSize=0x01;
        elif self.targetCombo.GetValue()=="Group":
            effectOut["Details"].targetSize=0x02;
        elif self.targetCombo.GetValue()=="All":
            effectOut["Details"].targetSize=0x04;
        elif self.targetCombo.GetValue()=="Player":
            effectOut["Details"].targetSize=0x08;
        elif self.targetCombo.GetValue()=="Party":
            effectOut["Details"].targetSize=0x10;
        elif self.targetCombo.GetValue()=="Self":
            effectOut["Details"].targetSize=0x20;

        effectOut["Details"].numSides=self.dieSpin.GetValue();
        effectOut["Details"].numDice=self.diceSpin.GetValue();
        effectOut["Details"].base=self.baseSpin.GetValue();

        if self.saveCombo.GetValue()=="Paralization/Poison/Death":
            effectOut["Details"].saveType=1;
        elif self.saveCombo.GetValue()=="Staff/Wand":
            effectOut["Details"].saveType=2;
        elif self.saveCombo.GetValue()=="Stoning/Polymorph":
            effectOut["Details"].saveType=3;
        elif self.saveCombo.GetValue()=="Breath/Spells":
            effectOut["Details"].saveType=4;
        elif self.saveCombo.GetValue()=="Psionics":
            effectOut["Details"].saveType=5;
        else:
            effectOut["Details"].saveType=0;

        effectOut["Details"].flagSpecial=0;
        effectOut["Details"].flagCondition=0;
        if self.resurrectBox.GetValue():
            effectOut["Details"].flagSpecial|=0x00000001;
        if self.stunnedBox.GetValue():
            effectOut["Details"].flagCondition|=0x00000001;
        if self.poisonBox.GetValue():
            effectOut["Details"].flagCondition|=0x00000002;
        if self.agedBox.GetValue():
            effectOut["Details"].flagCondition|=0x00000004;
        if self.sleepBox.GetValue():
            effectOut["Details"].flagCondition|=0x00000008;
        if self.blindBox.GetValue():
            effectOut["Details"].flagCondition|=0x00000010;
        if self.witheredBox.GetValue():
            effectOut["Details"].flagCondition|=0x00000080;
        if self.stoneBox.GetValue():
            effectOut["Details"].flagCondition|=0x00000100;

        return effectOut;

# end of class HealingDialog


