# generated by wxGlade 0.2.3 on Sat Jul 12 21:46:28 2003

from wxPython.wx import *

# begin wxGlade: dependencies
# end wxGlade

import bl3dGenericActionLoader
import StatDialog

class StatModConfigDialog(wxDialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: StatModConfigDialog.__init__
        kwds["style"] = wxDEFAULT_DIALOG_STYLE
        wxDialog.__init__(self, *args, **kwds)
        self.label_33 = wxStaticText(self, -1, "Range")
        self.rangeCombo = wxComboBox(self, -1, choices=["Melee", "20'", "30'", "40'", "50'", "60'", "70'", "80'", "90'"], style=wxCB_DROPDOWN|wxCB_READONLY)
        self.label_34 = wxStaticText(self, -1, "Target Type")
        self.targetCombo = wxComboBox(self, -1, choices=["Single", "Group", "All", "Player", "Party", "Self"], style=wxCB_DROPDOWN|wxCB_READONLY)
        self.label_35 = wxStaticText(self, -1, "Duration")
        self.durationCombo = wxComboBox(self, 1201, choices=["Combat", "Short", "Medium", "Long", "Indefinite", "Exact"], style=wxCB_DROPDOWN|wxCB_READONLY)
        self.label_36 = wxStaticText(self, -1, "Exact Duration")
        self.exactDurationSpin = wxSpinCtrl(self, -1, "0", min=0, max=10000, style=wxSP_ARROW_KEYS)
        self.label_37 = wxStaticText(self, -1, "Saving Throw Type")
        self.saveCombo = wxComboBox(self, -1, choices=["None", "Paralization/Poison/Death", "Staff/Wand", "Stoning/Polymorph", "Breath/Spells", "Psionics"], style=wxCB_DROPDOWN|wxCB_READONLY)
        self.panel_1 = wxPanel(self, -1)
        self.label_38 = wxStaticText(self, -1, "Special Modifiers")
        self.stunnedBox = wxCheckBox(self, -1, "Stunned")
        self.sleepBox = wxCheckBox(self, -1, "Sleeping")
        self.blindBox = wxCheckBox(self, -1, "Blind")
        self.agedBox = wxCheckBox(self, -1, "Aged")
        self.witheredBox = wxCheckBox(self, -1, "Withered")
        self.stoneBox = wxCheckBox(self, -1, "Stone")
        self.label_39 = wxStaticText(self, -1, "Modifiers")
        self.modifierList = wxListCtrl(self, -1, size=wxSize(-1,60), style=wxLC_REPORT|wxLC_SINGLE_SEL|wxSUNKEN_BORDER)
        self.addButton = wxButton(self, 1202, "Add Modifier")
        self.removeButton = wxButton(self, 1203, "Remove Modifier")
        self.okButton = wxButton(self, wxID_OK, "OK")
        self.cancelButton = wxButton(self, wxID_CANCEL, "Cancel")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        self.RegisterEvents();
        self.exactDurationSpin.Enable(0);

    def __set_properties(self):
        # begin wxGlade: StatModConfigDialog.__set_properties
        self.SetTitle("Stat Modifier Configuration")
        self.rangeCombo.SetSelection(0)
        self.targetCombo.SetSelection(0)
        self.durationCombo.SetSelection(0)
        self.saveCombo.SetSelection(0)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: StatModConfigDialog.__do_layout
        sizer_26 = wxBoxSizer(wxVERTICAL)
        sizer_33 = wxBoxSizer(wxHORIZONTAL)
        sizer_30 = wxBoxSizer(wxHORIZONTAL)
        sizer_32 = wxBoxSizer(wxVERTICAL)
        sizer_31 = wxBoxSizer(wxVERTICAL)
        grid_sizer_4 = wxGridSizer(2, 3, 5, 5)
        sizer_29 = wxBoxSizer(wxHORIZONTAL)
        sizer_28 = wxBoxSizer(wxHORIZONTAL)
        sizer_27 = wxBoxSizer(wxHORIZONTAL)
        sizer_27.Add(self.label_33, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_27.Add(self.rangeCombo, 1, wxRIGHT, 10)
        sizer_27.Add(self.label_34, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_27.Add(self.targetCombo, 1, 0, 0)
        sizer_26.Add(sizer_27, 0, wxALL|wxEXPAND, 5)
        sizer_28.Add(self.label_35, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_28.Add(self.durationCombo, 1, wxRIGHT, 10)
        sizer_28.Add(self.label_36, 0, wxRIGHT|wxALIGN_CENTER_VERTICAL, 5)
        sizer_28.Add(self.exactDurationSpin, 1, 0, 0)
        sizer_26.Add(sizer_28, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_29.Add(self.label_37, 0, wxRIGHT, 5)
        sizer_29.Add(self.saveCombo, 1, 0, 0)
        sizer_29.Add(self.panel_1, 1, wxEXPAND, 0)
        sizer_26.Add(sizer_29, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_26.Add(self.label_38, 0, wxLEFT|wxRIGHT|wxBOTTOM, 5)
        grid_sizer_4.Add(self.stunnedBox, 0, 0, 0)
        grid_sizer_4.Add(self.sleepBox, 0, 0, 0)
        grid_sizer_4.Add(self.blindBox, 0, 0, 0)
        grid_sizer_4.Add(self.agedBox, 0, 0, 0)
        grid_sizer_4.Add(self.witheredBox, 0, 0, 0)
        grid_sizer_4.Add(self.stoneBox, 0, 0, 0)
        sizer_26.Add(grid_sizer_4, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_31.Add(self.label_39, 0, wxBOTTOM, 5)
        sizer_31.Add(self.modifierList, 1, wxRIGHT|wxEXPAND, 5)
        sizer_30.Add(sizer_31, 2, wxEXPAND, 0)
        sizer_32.Add(self.addButton, 1, wxBOTTOM|wxEXPAND, 5)
        sizer_32.Add(self.removeButton, 1, wxTOP|wxEXPAND, 5)
        sizer_30.Add(sizer_32, 1, wxEXPAND, 0)
        sizer_26.Add(sizer_30, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        sizer_33.Add(self.okButton, 1, wxRIGHT|wxEXPAND, 5)
        sizer_33.Add(self.cancelButton, 1, wxEXPAND, 0)
        sizer_26.Add(sizer_33, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 5)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_26)
        sizer_26.Fit(self)
        sizer_26.SetSizeHints(self)
        self.Layout()
        # end wxGlade

    def RegisterEvents(self):
        EVT_COMBOBOX(self,1201,self.OnDuration);

        EVT_BUTTON(self,1202,self.OnAdd);
        EVT_BUTTON(self,1203,self.OnRemove);

    def OnDuration(self,evt):
        if self.durationCombo.GetValue()=="Exact":
            self.exactDurationSpin.Enable(1);
        else:
            self.exactDurationSpin.Enable(0);

    def OnAdd(self,evt):
        dlg=StatDialog.StatDialog(self,-1,"Stat Modifier",style=wxDEFAULT_DIALOG_STYLE);
        if dlg.ShowModal()==wxID_OK:
            newEffect=bl3dGenericActionLoader.bl3dGeneric_StatMod_Stat_Details()
            if dlg.statCombo.GetValue()=="Strength (ST)":
                newEffect.stat=0;
            elif dlg.statCombo.GetValue()=="Intelligence (IQ)":
                newEffect.stat=1;
            elif dlg.statCombo.GetValue()=="Wisdom (WI)":
                newEffect.stat=2;
            elif dlg.statCombo.GetValue()=="Dexterity (DX)":
                newEffect.stat=3;
            elif dlg.statCombo.GetValue()=="Constitution (CN)":
                newEffect.stat=4;
            elif dlg.statCombo.GetValue()=="Charisma (CH)":
                newEffect.stat=5;
            elif dlg.statCombo.GetValue()=="Comliness (CO)":
                newEffect.stat=6;
            elif dlg.statCombo.GetValue()=="Luck (LK)":
                newEffect.stat=7;
            elif dlg.statCombo.GetValue()=="Armor Class (AC)":
                newEffect.stat=8;
            elif dlg.statCombo.GetValue()=="Attack Bonus":
                newEffect.stat=9;
            elif dlg.statCombo.GetValue()=="Damage Bonus":
                newEffect.stat=10;
            elif dlg.statCombo.GetValue()=="Number of Attacks":
                newEffect.stat=11;
            elif dlg.statCombo.GetValue()=="% Chance to Avoid Fire":
                newEffect.stat=13;
            elif dlg.statCombo.GetValue()=="% Modifier for Damage from Fire":
                newEffect.stat=14;
            elif dlg.statCombo.GetValue()=="% Chance to Avoid Earth":
                newEffect.stat=15;
            elif dlg.statCombo.GetValue()=="% Modifier for Damage from Earth":
                newEffect.stat=16;
            elif dlg.statCombo.GetValue()=="% Chance to Avoid Air":
                newEffect.stat=17;
            elif dlg.statCombo.GetValue()=="% Modifier for Damage from Air":
                newEffect.stat=18;
            elif dlg.statCombo.GetValue()=="% Chance to Avoid Water":
                newEffect.stat=19;
            elif dlg.statCombo.GetValue()=="% Modifier for Damage from Water":
                newEffect.stat=20;
            elif dlg.statCombo.GetValue()=="Back-damage":
                newEffect.stat=21;
            newEffect.modAmt=dlg.amtSpin.GetValue();
            self.modList.append(newEffect);
            self.UpdateDisplay();

        dlg.Destroy()

    def OnRemove(self,evt):
        newlist=[];
        idx=self.modifierList.GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
        if idx < 0:
            return

        self.modList=self.modList[:idx]+self.modList[idx+1:];

        self.UpdateDisplay()

    def InitNewEffect(self):
        self.modList=[];
        self.UpdateDisplay();

    def InitEffect(self,effectIn):
        if effectIn["Details"].range == 10:
            self.rangeCombo.SetValue("Melee");
        elif effectIn["Details"].range == 20:
            self.rangeCombo.SetValue("20'");
        elif effectIn["Details"].range == 30:
            self.rangeCombo.SetValue("30'");
        elif effectIn["Details"].range == 40:
            self.rangeCombo.SetValue("40'");
        elif effectIn["Details"].range == 50:
            self.rangeCombo.SetValue("50'");
        elif effectIn["Details"].range == 60:
            self.rangeCombo.SetValue("60'");
        elif effectIn["Details"].range == 70:
            self.rangeCombo.SetValue("70'");
        elif effectIn["Details"].range == 80:
            self.rangeCombo.SetValue("80'");
        elif effectIn["Details"].range == 90:
            self.rangeCombo.SetValue("90'");

        if effectIn["Details"].targetSize & 0x01:
            self.targetCombo.SetValue("Single");
        if effectIn["Details"].targetSize & 0x02:
            self.targetCombo.SetValue("Group");
        if effectIn["Details"].targetSize & 0x04:
            self.targetCombo.SetValue("All");
        if effectIn["Details"].targetSize & 0x08:
            self.targetCombo.SetValue("Player");
        if effectIn["Details"].targetSize & 0x10:
            self.targetCombo.SetValue("Party");
        if effectIn["Details"].targetSize & 0x20:
            self.targetCombo.SetValue("Self");

        if effectIn["Details"].duration==1:
            self.durationCombo.SetValue("Combat");
        if effectIn["Details"].duration==2:
            self.durationCombo.SetValue("Short");
        if effectIn["Details"].duration==3:
            self.durationCombo.SetValue("Medium");
        if effectIn["Details"].duration==4:
            self.durationCombo.SetValue("Long");
        if effectIn["Details"].duration==5:
            self.durationCombo.SetValue("Indefinite");
        if effectIn["Details"].duration==6:
            self.durationCombo.SetValue("Exact");
            self.exactDurationSpin.SetValue(effectIn["Details"].durationExact);

        if effectIn["Details"].saveType==0:
            self.saveCombo.SetValue("None");
        elif effectIn["Details"].saveType==1:
            self.saveCombo.SetValue("Paralization/Poison/Death");
        elif effectIn["Details"].saveType==2:
            self.saveCombo.SetValue("Staff/Wand");
        elif effectIn["Details"].saveType==3:
            self.saveCombo.SetValue("Stoning/Polymorph");
        elif effectIn["Details"].saveType==4:
            self.saveCombo.SetValue("Breath/Spells");
        elif effectIn["Details"].saveType==5:
            self.saveCombo.SetValue("Psionics");
        else:
            self.saveCombo.SetValue("None");

        if effectIn["Details"].specialFlags&0x00000001:
            self.stunnedBox.SetValue(1);
        if effectIn["Details"].specialFlags&0x00000004:
            self.agedBox.SetValue(1);
        if effectIn["Details"].specialFlags&0x00000008:
            self.sleepBox.SetValue(1);
        if effectIn["Details"].specialFlags&0x00000010:
            self.blindBox.SetValue(1);
        if effectIn["Details"].specialFlags&0x00000080:
            self.witheredBox.SetValue(1);
        if effectIn["Details"].specialFlags&0x00000100:
            self.stoneBox.SetValue(1);

        self.modList=effectIn["Mods"];

        self.OnDuration(None);
        self.UpdateDisplay();

    def GetEffect(self):
        effectOut={};
        effectOut["Header"]=bl3dGenericActionLoader.bl3dGeneric_Action_Detail_Header();
        effectOut["Details"]=bl3dGenericActionLoader.bl3dGeneric_StatMod_Details()
        effectOut["Header"].type=bl3dGenericActionLoader.BL3D_GENERIC_ACTION_STATMOD;
        effectOut["Header"].length=16+len(self.modList)*4;

        if self.rangeCombo.GetValue()=="Melee":
            effectOut["Details"].range=10;
        elif self.rangeCombo.GetValue()=="20'":
            effectOut["Details"].range=20;
        elif self.rangeCombo.GetValue()=="30'":
            effectOut["Details"].range=30;
        elif self.rangeCombo.GetValue()=="40'":
            effectOut["Details"].range=40;
        elif self.rangeCombo.GetValue()=="50'":
            effectOut["Details"].range=50;
        elif self.rangeCombo.GetValue()=="60'":
            effectOut["Details"].range=60;
        elif self.rangeCombo.GetValue()=="70'":
            effectOut["Details"].range=70;
        elif self.rangeCombo.GetValue()=="80'":
            effectOut["Details"].range=80;
        elif self.rangeCombo.GetValue()=="90'":
            effectOut["Details"].range=90;

        if self.targetCombo.GetValue()=="Single":
            effectOut["Details"].targetSize=0x01;
        elif self.targetCombo.GetValue()=="Group":
            effectOut["Details"].targetSize=0x02;
        elif self.targetCombo.GetValue()=="All":
            effectOut["Details"].targetSize=0x04;
        elif self.targetCombo.GetValue()=="Player":
            effectOut["Details"].targetSize=0x08;
        elif self.targetCombo.GetValue()=="Party":
            effectOut["Details"].targetSize=0x10;
        elif self.targetCombo.GetValue()=="Self":
            effectOut["Details"].targetSize=0x20;

        if self.saveCombo.GetValue()=="Paralization/Poison/Death":
            effectOut["Details"].saveType=1;
        elif self.saveCombo.GetValue()=="Staff/Wand":
            effectOut["Details"].saveType=2;
        elif self.saveCombo.GetValue()=="Stoning/Polymorph":
            effectOut["Details"].saveType=3;
        elif self.saveCombo.GetValue()=="Breath/Spells":
            effectOut["Details"].saveType=4;
        elif self.saveCombo.GetValue()=="Psionics":
            effectOut["Details"].saveType=5;
        else:
            effectOut["Details"].saveType=0;

        if self.durationCombo.GetValue()=="Combat":
            effectOut["Details"].duration=1;
        elif self.durationCombo.GetValue()=="Short":
            effectOut["Details"].duration=2;
        elif self.durationCombo.GetValue()=="Medium":
            effectOut["Details"].duration=3;
        elif self.durationCombo.GetValue()=="Long":
            effectOut["Details"].duration=4;
        elif self.durationCombo.GetValue()=="Indefinite":
            effectOut["Details"].duration=5;
        elif self.durationCombo.GetValue()=="Exact":
            effectOut["Details"].duration=6;
            effectOut["Details"].durationExact=self.exactDurationSpin.GetValue();

        effectOut["Details"].specialFlags=0;
        if self.stunnedBox.GetValue():
            effectOut["Details"].specialFlags|=0x00000001;
        if self.agedBox.GetValue():
            effectOut["Details"].specialFlags|=0x00000004;
        if self.sleepBox.GetValue():
            effectOut["Details"].specialFlags|=0x00000008;
        if self.blindBox.GetValue():
            effectOut["Details"].specialFlags|=0x00000010;
        if self.witheredBox.GetValue():
            effectOut["Details"].specialFlags|=0x00000080;
        if self.stoneBox.GetValue():
            effectOut["Details"].specialFlags|=0x00000100;

        effectOut["Details"].numStatMods=len(self.modList);
        effectOut["Mods"]=self.modList;
            
        return effectOut;

    def UpdateDisplay(self):
        self.modifierList.ClearAll();
        self.modifierList.InsertColumn(0,"Stat");
        self.modifierList.InsertColumn(1,"Amount");

        for i in range(0,len(self.modList)):
            mod=self.modList[i];
            if mod.stat==0:
                self.modifierList.InsertStringItem(i,"Strength");
            elif mod.stat==1:
                self.modifierList.InsertStringItem(i,"Intelligence");
            elif mod.stat==2:
                self.modifierList.InsertStringItem(i,"Wisdom");
            elif mod.stat==3:
                self.modifierList.InsertStringItem(i,"Dexterity");
            elif mod.stat==4:
                self.modifierList.InsertStringItem(i,"Constitution");
            elif mod.stat==5:
                self.modifierList.InsertStringItem(i,"Charisma");
            elif mod.stat==6:
                self.modifierList.InsertStringItem(i,"Comliness");
            elif mod.stat==7:
                self.modifierList.InsertStringItem(i,"Luck");
            elif mod.stat==8:
                self.modifierList.InsertStringItem(i,"Armor Class");
            elif mod.stat==9:
                self.modifierList.InsertStringItem(i,"Attack Bonus");
            elif mod.stat==10:
                self.modifierList.InsertStringItem(i,"Damage Bonus");
            elif mod.stat==11:
                self.modifierList.InsertStringItem(i,"# of Attacks");
            elif mod.stat==13:
                self.modifierList.InsertStringItem(i,"Fire Resistance");
            elif mod.stat==14:
                self.modifierList.InsertStringItem(i,"Fire Damage");
            elif mod.stat==15:
                self.modifierList.InsertStringItem(i,"Earth Resistance");
            elif mod.stat==16:
                self.modifierList.InsertStringItem(i,"Earth Damage");
            elif mod.stat==17:
                self.modifierList.InsertStringItem(i,"Air Resistance");
            elif mod.stat==18:
                self.modifierList.InsertStringItem(i,"Air Damage");
            elif mod.stat==19:
                self.modifierList.InsertStringItem(i,"Water Resistance");
            elif mod.stat==20:
                self.modifierList.InsertStringItem(i,"Water Damage");
            elif mod.stat==21:
                self.modifierList.InsertStringItem(i,"Back-Damage");
            self.modifierList.SetStringItem(i,1,"%d"%(mod.modAmt));

# end of class StatModConfigDialog


